﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Urlopy - plan</title>
		<script runat="server">

            public class PrnParams : ContextBase {

                public PrnParams(Context context): base(context) {
                    definicja = KalendModule.GetInstance(this).DefinicjeLimitow.UrlopWypoczynkowy;
                    stanNaDzień = ((ActualDate)Context[typeof(ActualDate)]).Actual;
                    okres = FromTo.Year(stanNaDzień.Year);
                }
                
                FromTo okres;
                [Caption("Raport za okres")]
                [Priority(10)]
                public FromTo Okres {
                    get { return okres; }
                }

                Date stanNaDzień;
                [Priority(20)]
                [Caption("Stan na dzień")]
                public Date StanNaDzień {
                    get { return stanNaDzień; }
                }
                
                DefinicjaLimitu definicja;
                [Caption("Nieobecność")]
                [Required]
                [Priority(30)]
                public DefinicjaLimitu Nieobecność {
                    get { return definicja; }
                    set {
                        definicja = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListNieobecność() {
                    Soneta.Business.View view = KalendModule.GetInstance(this).DefinicjeLimitow.WgNazwy.CreateView();
                    view.Condition &= new FieldCondition.Equal("Naliczanie", NaliczanieLimitu.WypoczynkowyNaGodziny);
                    return view;
                }
            }

            PrnParams pars = null;
            [Context(Required = true)]
            public PrnParams Params {
                set { pars = value; }
            } 
		    
	KalendModule kalend;
	DefinicjaLimitu definicja;
    Date stanNaDzień;
    FromTo okresRok;
    FromTo okresNie;
    FromTo okresPoz;
    Log log;    
	
	void OnContextLoad(Object sender, EventArgs args) {
        stanNaDzień = pars.StanNaDzień;
        okresRok = pars.Okres;
        okresNie = okresRok * new FromTo(Date.MinValue, stanNaDzień);
        if (stanNaDzień < okresRok.To)
            okresPoz = new FromTo(stanNaDzień.AddDays(1), okresRok.To);
        else
            okresPoz = FromTo.Empty;
        kalend = KalendModule.GetInstance(dc);
        definicja = pars.Nieobecność;

        ReportHeader1["ROK"] = okresRok.From.Year.ToString();
        ReportHeader1["DATA"] = stanNaDzień.ToString();
        ReportHeader1["DEFINICJA"] = definicja.Nazwa;

        if (dc.Landscape)
            prac.Width += 20;
        else
            zaległyW.Visible = urlopW.Visible = false;

        log = new Log("Wydruk: Urlopy - na dzień", true);        
	}

    private Time WyliczNieobecnosci(PracHistoria ph, FromTo okres, bool uwnz) {
        KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);
        Time urlop = Time.Zero;

        foreach (OkresNieobecności n in kalk.Nieobecnosci(okres * ph.Etat.OkresZatrudnienia, true)) {
            if (n.Definicja.Limit != definicja)
                continue;
            if (uwnz && n.Urlop.Przyczyna != PrzyczynaUrlopu.NaŻądanie)
                continue;
            Nieobecnosc no = (Nieobecnosc)n;
            if (no.Okres.Days == 1 && no.Norma > Time.Zero)
                urlop += no.Norma;
            else
                urlop += kalk.Plan.Norma(n.Okres).Czas;
        }
        
        return urlop;            
    }
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        PracHistoria ph = (PracHistoria)args.Row;

        if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowy ||
            ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowyZaGranicą) {
            args.VisibleRow = false;
            if (log != null)
                log.WriteLine("Pracownik " + ph.Pracownik + " został odrzucony - pracownik ma ustawiony rodzaj zatrudnienia jako tymczasowy");                        
            return;
        }
        
        Time korekta = Time.Zero;
        Time zaległy = Time.Zero;
        Time wykorzystany = Time.Zero;
        Time urlopZadanie = Time.Zero;
        Time limit = Time.Zero;
        
        IEnumerable limity = kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][okresRok];
        Date prev = Date.Empty;
        foreach (LimitNieobecnosci l in limity) {
            if (prev != Date.Empty && prev + 1 < l.Okres.From) {
                if (l.Okres.From > stanNaDzień)
                    break;
                else {
                    zaległy = Time.Zero;
                    limit = Time.Zero;
                    korekta = Time.Zero;
                    wykorzystany = Time.Zero;
                }
            }
            else if (prev != Date.Empty && prev + 1 == l.Okres.From) {
                if (l.Okres.From > stanNaDzień)
                    break;
            }
            else if (prev == Date.Empty && l.Okres.From > stanNaDzień)
                break;
            else if (l.Okres.From.Month == 1 && l.Okres.From.Day == 1)
                zaległy = l.PrzeniesienieGodz;
            limit += l.LimitGodz - l.WykorzystanyPoprzGodz;
            korekta += l.ZmianaGodz;
            wykorzystany += l.WykorzystaneGodz;
            prev = l.Okres.To;
        }

        wykorzystany -= WyliczNieobecnosci(ph, okresPoz, false);
        urlopZadanie = WyliczNieobecnosci(ph, okresNie, true);
        wykorzystany -= urlopZadanie;
        
        zaległy += korekta;
        if (zaległy < Time.Zero) {
            limit += zaległy;
            zaległy = Time.Zero;
        }
        
        Fraction wymiar = ph.Etat.Wymiar;
        if (wymiar == Fraction.Zero)
            wymiar = Fraction.One;

        Time norma = ph.Etat.Kalendarz.NormaDobowa;
        if (norma == Time.Zero)
            norma = new Time(8, 0);

        Time p = Time.Zero;
        zaległyG.EditValue = Wylicz(zaległy, norma, wymiar);
        if (wykorzystany <= zaległy) {
            zaległyW.EditValue = Wylicz(wykorzystany, norma, wymiar);
            zaległyP.EditValue = Wylicz(zaległy - wykorzystany, norma, wymiar);
            p = zaległy - wykorzystany;
            wykorzystany = Time.Zero;
        }
        else {
            zaległyW.EditValue = Wylicz(zaległy, norma, wymiar);
            wykorzystany -= zaległy;
        }
        wykorzystany += urlopZadanie;

        urlopG.EditValue = Wylicz(limit, norma, wymiar);
        urlopW.EditValue = Wylicz(wykorzystany, norma, wymiar);
        urlopP.EditValue = Wylicz(limit - wykorzystany, norma, wymiar);

        p += limit - wykorzystany;
        
        razemP.EditValue = Wylicz(p, norma, wymiar);
    }

    string Wylicz(Time t, Time norma, Fraction wymiar) {
        double d = Soneta.Tools.Math.Round(t / norma / wymiar, 2);
        if (t == Time.Zero && d == 0.0)
            return "";
        return string.Format("{0}/{1}", t, d); ;
    }
		            
	public static object Msg(object obj) {
		return obj;
	}

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body> 
		<form id="UrlopyPlan" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"
				oncontextload="OnContextLoad" Landscape="True"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                title="Wykorzystanie urlopów|&lt;/strong&gt;Definicja: &lt;strong&gt; %DEFINICJA%|&lt;/strong&gt;Rok: &lt;strong&gt;%ROK%|&lt;/strong&gt;Wg stanu na dzień: &lt;strong&gt;%DATA%" 
                runat="server"></cc1:reportheader><ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"
				LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="20" DataMember="Etat.Wydzial.Kod" Caption="Nazwa działu zakładu pracy" NoWrap="True" EncodeHTML="true" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="prac" DataMember="Pracownik.NazwiskoImię" 
                        Caption="Nazwisko i imię pracownika" NoWrap="True" runat="server" 
                        Width="30" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn Align="Center" Caption="Zaległy~wymiar" HideZero="True" 
                        runat="server" ID="zaległyG"></ea:GridColumn>
					<ea:GridColumn runat="server" Caption="Zaległy~wykorzystany" 
                        HideZero="True" ID="zaległyW" Align="Center">
                    </ea:GridColumn>
					<ea:GridColumn Caption="Zaległy~pozostaje" runat="server" HideZero="True" 
                        ID="zaległyP" Align="Center"></ea:GridColumn>
                    <ea:GridColumn ID="urlopG" runat="server" Align="Center" Caption="Bieżący~wymiar"
                        HideZero="True">
                    </ea:GridColumn>
					<ea:GridColumn runat="server" Caption="Bieżący~wykorzystany" 
                        HideZero="True" ID="urlopW" Align="Center">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Bieżący~pozostaje" HideZero="True" 
                        ID="urlopP" Align="Center">
                    </ea:GridColumn>
				    <ea:GridColumn ID="razemP" runat="server" Caption="Razem|pozostaje" 
                        Align="Center" HideZero="True">
                    </ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
